<?php

namespace App\Http\Controllers;

use App\Like;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LikeController extends Controller
{
    /**
     * Toggle like status for a blog post.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function toggle(Request $request)
    {
        $blogId = $request->item;
        $userId = Auth::id();

        $like = Like::where('user_id', $userId)->where('blog_id', $blogId)->first();

        if ($like) {
            if ($like->added == 1) {
                $like->delete();
                $action = 'unliked';
            } else {
                $like->update(['added' => 1]);
                $action = 'liked';
            }
        } else {
            Like::create([
                'added' => 1,
                'blog_id' => $blogId,
                'user_id' => $userId
            ]);
            $action = 'liked';
        }

        $likeCount = Like::where('blog_id', $blogId)->where('added', 1)->count();
        $unlikeCount = Like::where('blog_id', $blogId)->where('added', -1)->count();

        return response()->json([
            'status' => 'success',
            'message' => "Post {$action} successfully!",
            'likeCount' => $likeCount,
            'unlikeCount' => $unlikeCount,
            'action' => $action
        ]);
    }

    /**
     * Toggle unlike status for a blog post.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function toggleUnlike(Request $request)
    {
        $blogId = $request->item;
        $userId = Auth::id();

        $like = Like::where('user_id', $userId)->where('blog_id', $blogId)->first();

        if ($like) {
            if ($like->added == -1) {
                $like->delete();
                $action = 'removed unlike';
            } else {
                $like->update(['added' => -1]);
                $action = 'unliked';
            }
        } else {
            Like::create([
                'added' => -1,
                'blog_id' => $blogId,
                'user_id' => $userId
            ]);
            $action = 'unliked';
        }

        $likeCount = Like::where('blog_id', $blogId)->where('added', 1)->count();
        $unlikeCount = Like::where('blog_id', $blogId)->where('added', -1)->count();

        return response()->json([
            'status' => 'success',
            'message' => "Post {$action} successfully!",
            'likeCount' => $likeCount,
            'unlikeCount' => $unlikeCount,
            'action' => $action
        ]);
    }
}